#include <pads.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sgtty.h>
#include <stdio.h>
#include <sys/param.h>
#include <errno.h>
#include "lib.h"
#include <ctype.h>
#include <stdarg.h>
SRCFILE("lib.c")

char *basename(char *path)
{
	char *lsi = strrchr(path, '/');
	return lsi ? lsi+1 : path; 
}

char *slashname(char *path)
{
	return sf("%0.*s", strlen(path)-strlen(basename(path)),  path);
}

int alldigits(char *p)
{
	if( !p ) return 0;
	while( isdigit(*p) ) ++p;
	return !*p;
}

char *Name(char *s, int i)
{
	static char buf[8][32];
	static cycle;
	char *t = buf[(cycle++,cycle%=8)];
	sprintf( t, s, i );
	return t;
}
	
char *SysErr(char *s)
{
	extern int errno, sys_nerr;
	extern char *sys_errlist[];

	if( errno>=sys_nerr || errno<1 ) return sf( "%s errno=%d", s, errno);
	return sf( "%s %s", s, sys_errlist[errno] );
}

char *strcatfmt(char *s, PRINTF_ARGS )
{
	PRINTF_PROLOGUE;
	sprintf( &s[strlen(s)], PRINTF_COPY);
	return s;
}

int ReadOK( int fd, char *addr, int req )
{
	int got;

	got = read(fd,addr,req);
	trace( "ReadOK(%d,%d,%d) %d", fd, addr, req, got );
	return got == req;
}

int WriteOK( int fd, char *addr, int req )
{
	int got;

	got = write(fd,addr,req);
	trace( "WriteOK(%d,%d,%d) %d", fd, addr, req, got );
	return got == req;
}

long modified( int fd )
{
	struct stat buf;

	fstat( fd, &buf );
	trace( "fd=%d buf.st_mtime=%d", fd, buf.st_mtime );
	return buf.st_mtime;
}

char *pathexpand(char *f, char *path, int a)
{
	static char file[128];
	register char *p;

	if (!strncmp(f, "./", 2) || !strncmp(f, "../", 3)) {
		if (access(f, a) != -1)
			return f;
	}
	if (*f != '/' && path) {
		while(*path){
			for(p=file; *path && *path!=':';)
				*p++ = *path++;
			if(p!=file)
				*p++='/';
			if(*path)
				path++;
			(void)strcpy(p, f);
			if (access(file, a) != -1)
				return file;
		}
	}
	if (access(f, a) != -1)
		return f;
	return 0;
}
